/**
 * 
 */
package gov.va.genisis2.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.genisis2.dto.WorkflowStatusDTO;
import gov.va.genisis2.model.WorkflowStatus;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

/**
 * @author Paramjeet Bindra
 *
 */
@Component
public class WorkflowStatusConverter implements Converter<List<WorkflowStatus>, List<WorkflowStatusDTO>> {
	
	@Override
	public List<WorkflowStatusDTO> convert(List<WorkflowStatus> requestStatusCounts) {
		List<WorkflowStatusDTO> listWorkflowStatusDTO = new ArrayList<>();
		for (WorkflowStatus WorkflowStatus : requestStatusCounts) {
			WorkflowStatusDTO workflowStatusDTO = new WorkflowStatusDTO();
			workflowStatusDTO.setDescription(WorkflowStatus.getDescription());
			workflowStatusDTO.setId(WorkflowStatus.getStatus());
			if (WorkflowStatus.getCount() == null) {
				workflowStatusDTO.setCount(0L);
			} else {
				workflowStatusDTO.setCount(WorkflowStatus.getCount());
			}

			listWorkflowStatusDTO.add(workflowStatusDTO);
		}
		
		return listWorkflowStatusDTO;
	}
}